# Contributing

> I welcome feature requests and bug reports. Please read these guidelines before submitting one.

From opening a bug report to creating a pull request: every contribution is appreciated and welcomed.

# Your first Contribution

First of all, you will need to create an issue in Github for the feature or bugfix that you want to work on. When you open a new issue, there will be a template that will be automatically added to the text of the issue, which you would need to fill in. Doing this will help us to understand better what the ticket is about.

After you've created the issue, we will have a look, and provide feedback to your ticket.

In case it is a bug that you want to fix, we might help you with background information about the issue, so you can make an informed fix.

Words that begin with the at sign (@) must be wrapped in backticks! . As a courtesy to avoid sending notifications to any user that might have the @username being referenced, please remember that GitHub usernames also start with the at sign. 

If you don't wrap them in backticks, users will get unintended notifications from you.

In case you are suggesting a new feature, we will match your idea with our current roadmap, and will open conversations about it. Once the discussion has been done, and the tasks cleared, then you're ready to code.

GitHub has other great markdown features as well, go [here](https://help.github.com/categories/writing-on-github/) to learn more about them.

# Reporting Issues

Most of the time, when webpack does not work correctly, it might be a configuration issue.

If you are still having difficulty after looking over your configuration carefully, please post a question to [StackOverflow with the MVC tag](http://stackoverflow.com/tags/autoloader). This way you help others to help you.

> You should also have Google search and other plattforms included.

**If you have discovered a bug or have a feature suggestion, feel free to create an issue on Github.**

It can happen again and again that mistakes have crept in and the code does not work smoothly. That's why you can open a ticket here and get help. However, it should be checked beforehand if someone already had this error and he was already helped.

### Creating branch

Making a branch in your fork for your contribution is helpful in the following ways:

* It allows you to submit more than one contribution in a single PR.
* It allows us to identify what your contribution is about from the branch name.

You will want to checkout the `main` branch locally before creating your new branch.

There are two types of branches:

* Feature
* Bugfix

### Features

If your contribution is something new, like an option for the cli, you can create a branch with the following prefix:

`feature/<the-new-feature>`

### Fixes

If you are fixing an existing bug, you can create a branch with the following prefix:

`bugfix/<the-fix>`

### Testing

Any bug fix or feature you submit needs to be tested. Writing tests for code is very important to avoid future errors and to immediately detect potential new errors.

It's important that you test the logic of the code you're writing, and that your tests really go through all the lines, branches, and instructions. Only in this way can it be ensured that the code coverage is high enough to ensure that the users of the generator use a solid tool.

If you need help or need advice on writing your tests, please contact us. We would like to point you in the right direction.

Write here your [issues](https://github.com/prod3v3loper/php-auto-autoloader/issues).

# Pull Requests

After receiving some feedback, press down on your fork and submit a pull request. We can suggest some changes, improvements or implementation alternatives.

Create a new industry as described above.

If you made a small change in most cases, your pull request will be accepted faster.

### Submitting a good Pull Request

* Test before submit
* Follow our code convention
* Write a good commit message

Show all [pulls](https://github.com/prod3v3loper/php-auto-autoloader/pulls).