<div align="center">

# 🏗 PHP Auto Autoloader 

With this autoloader, you do not need any more, no matter where you have a master in your root, the autoloader of MB tnado Ai will find it. The classes found can be indexed to retry without searching.

# Usage

</div>

Instantiate your classes, interfaces, traits or even abstract classes, no matter where.
The only thing you have to do is to integrate.

## Packagist with Composer

This solution extends the vendor autoloader because it calls the files with certain criteria. The extension allows you to call classes wherever the Autoloader is involved.

Download [Composer](https://getcomposer.org/) local or global. Check for more [Tutorial - NetBeans with Composer and Packagist](https://www.tnado.com/blog/netbeans-with-composer-and-packagist-the-php-package-manager/) for this one.

You found the Autoloader package on [Packagist - PHP Auto Autoloader](https://packagist.org/packages/prod3v3loper/php-auto-autoloader).

Add the Autoloader dependencie to the **composer.json** and set the autoload.
```json
{
    ...
    "autoload": {
        "psr-4": { "Aautoloder\\": "autoload/src" }
    },
    "require": {
        "prod3v3loper/php-auto-autoloader": ">=1.0"
    }
    ...
}
```

Now run the composer install command with php
```
php composer.phar install
```
e.g.
```
composer install
```

This is the vendor autoloader invites our autoloader and now we do not need to specify any more class and can load all our classes.

`index.php`
```php
<?php
// Define the document root project folder
define('MBT_DOCUMENT_ROOT', __DIR__);

// Load the autoloader
require_once __DIR__ . '/vendor/autoload.php';
new \Aautoloder\Loader(array(MBT_DOCUMENT_ROOT));
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>Prod3v3loper - Autoload</title>
    </head>
    <body>
        <?php

        // METHOD 1: Fastest way, the namespace is foldername structure and filename is equal to filename
        $class_one = new testclasses\first_class();
        $class_one->method_from_first_class();

        // METHOD 2: The slower way, namespace is equal to folder structure but the classname is differnt to the filename
        $class_two = new testclasses\classes\second_class();
        $class_two->method_from_second_class();

        // METHOD 3: The slowest way, here ist nothing euqal
        $three_class = new name_space\namespace2\third_class();
        $three_class->method_from_third_class();
        
        ?>
    </body>
</html>
```

## Git clone

Get per [Git](https://git-scm.com/) or [download](https://github.com/prod3v3loper/php-auto-autoloader/archive/master.zip) and use it.

```
git clone https://github.com/prod3v3loper/php-auto-autoloader.git /projects/
```

So we use it without a vendor and can start a direct call.

`index.php`
```php
<?php
// Define the document root project folder
define('MBT_DOCUMENT_ROOT', __DIR__);

// Load the autoloader
require_once './autoload/src/Loader.php';
new \Aautoloder\Loader(array(MBT_DOCUMENT_ROOT));
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>Prod3v3loper - Autoload</title>
    </head>
    <body>
        <?php

        // METHOD 1: Fastest way, the namespace is foldername structure and filename is equal to filename
        $class_one = new testclasses\first_class();
        $class_one->method_from_first_class();

        // METHOD 2: The slower way, namespace is equal to folder structure but the classname is differnt to the filename
        $class_two = new testclasses\classes\second_class();
        $class_two->method_from_second_class();

        // METHOD 3: The slowest way, here ist nothing euqal
        $three_class = new name_space\namespace2\third_class();
        $three_class->method_from_third_class();
        
        ?>
    </body>
</html>
```
<div align="center">

# Core Settings & Debug

</div>

`autoload/core.config.php`

Indexing of the found classes, default is `true`.
```php
define('MBT_CORE_AUTOLOAD_INDEX', true);
```

Maximum number of lines to read in a file, default is `49`.
```php
define('MBT_CORE_AUTOLOAD_READ_MAX_LINES', 49);
```

Set this to false so that you no longer see the debugging, default is `true`.
```php
define('MBT_DEBUG_DISPLAY_AUTOLOAD', true);
```

Look at which classes where were found, default is `true`.
```php
define('MBT_DEBUG_DISPLAY_AUTOLOAD_SEARCH', true);
```

<div align="center">

# Root

</div>

The complete path is the directory path, that the autoloader get by self.

DEFAULT: `MBT_DOCUMENT_ROOT`

The autoloader define get the web root by self after set `MBT_DOCUMENT_ROOT`
```php
define('MBT_DOCUMENT_ROOT', __DIR__);

define('MBT_SERVER_ROOT', str_replace(MBT_DOCUMENT_ROOT, '', str_replace(filter_input(INPUT_SERVER, 'DOCUMENT_ROOT'), '', str_replace("\\", "/", MBT_DOCUMENT_ROOT))));
define('MBT_HTTP_ROOT', get_protocol() . get_host() . MBT_SERVER_ROOT);
```

<div align="center">

# Loader methods

</div>

The autoloader finds everything yourself you do not have to do anything except write your class and instance and use.

Method | Namespace (with class) | Path | Load Time
------------ | ------------ | ------------- | -------------
1 | testclasses\first_class | php-auto-autoloader/testclasses/first_class.php | 0.0 sec.
2 | testclasses\classes\second_class | php-auto-autoloader/testclasses/classes/second.php | 0.002 sec.
3 | name_space\namespace2\third_class | php-auto-autoloader/testclasses/classThree.php | 0.011 sec.

## METHOD 1:

> This is the fastest way

That means we take the website root path and namespace as a folder path and the classname we put together with these.

### Example

**The instance:**
`new testclasses\first_class();`

Type | Sample | Description
---- | ------ | ------
PATH | `/project/sites/mywebsite/` | MBT_DOCUMENT_ROOT
NAMESPACE | `testclasses` | Like the folder name
CLASS | `first_class` | Like the file name without extension
Then the result example | `/project/sites/mywebsite/testclasses/first_class.php` | 

## METHOD 2:

> This method is slightly slower than the first, so 0.03 - 0.05 seconds

This function namespace as folder path and force only this path for class `second_class` (Example) file.
However, this only occurs when the file does not match the specified class name.
This means every file found in this folder is opened and searched for the classname. 
As soon as the used class exists in a file, this is integrated and can use it.

### Example

**The instance:**
`new testclasses\classes\second_class();`

Type | Sample | Description
---- | ------ | ------
PATH | `/project/sites/website/` | MBT_DOCUMENT_ROOT
NAMESPACE | `testclasses\classes` | Like the folder name
Then the result example | `/project/sites/mywebsite/testclasses/classes/second_class.php` | 

## METHOD 3:

> This method is the slowest, but found class anything where

This method is the slowest, because it scans all your folders. 
No matter how much files you have, all are opened, read and searched for the classname. 
This method intervenes only when none of the other methods was successful. So if the namespace was not just a folder name and the class name was not filename.

### Example

**The instance:**
`new testclasses\classes\third_class();`

Type | Sample | Description
---- | ------ | ------
PATH | `/project/sites/mywebsite/` | MBT_DOCUMENT_ROOT
Then the result example | `/project/sites/mywebsite/testclasses/classThree.php` | 

<div align="center">

# Authors

**prod3v3loper** - *All works*

# License

MIT - prod3v3loper

</div>