<?php

declare(strict_types=1);

namespace Aautoloder\Test;

define('MBT_DOCUMENT_ROOT', dirname(__DIR__));

use PHPUnit\Framework\TestCase;
use Aautoloder\Loader;

/**
 * PHPUnit Test example
 * 
 * @author      prod3v3loper
 * @copyright   (c) 2024, prod3v3loper
 * @link        https://www.prod3v3loper.com/
 * @package     Melabuai
 * @subpackage  Autoloader
 * @version     1.1
 * @since       1.1
 * @see         https://github.com/prod3v3loper/php-auto-autoloader
 */
class LoaderTest extends TestCase
{
    public function testAutoloaderInstance(): void
    {
        $loader = new \Aautoloder\Loader(array(MBT_DOCUMENT_ROOT));

        // Assert
        $this->assertInstanceOf(
            Loader::class,
            $loader,
            'Failed to assert that the autoloader instance is of type \Aautoloder\Loader'
        );
    }

    public function testHasClassAttribute(): void
    {
        $this->assertTrue(
            property_exists(Loader::class, 'dir'),
            'The class Aautoloder\Loader does not have the attribute "dir".'
        );
    }

    public function testClassNotFound()
    {
        // Arrange
        $loader = new Loader([MBT_DOCUMENT_ROOT]);

        // Act & Assert
        $this->expectException(\Throwable::class);
        try {
            new \Namespace\That\Does\Not\Exist();
        } catch (\Throwable $exception) {
            // Assert
            $this->assertEquals('Class "Namespace\That\Does\Not\Exist" not found', $exception->getMessage());
            throw $exception;
        }
    }
}
